<?php
namespace Import\ApiBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ImportDelegationCostsCommand extends ContainerAwareCommand
{
    /**
     * @var \Symfony\Component\DependencyInjection\Container
     */
    private $Container;
    private $input;
    private $output;

    protected function configure()
    {
        $this
            ->setName('import:delegation:costs')
            ->setDescription('Import delegation costs')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $timeStart = new \DateTime();
        $this->input = $input;
        $this->output = $output;
        $this->Container = $this->getContainer();

        $this->executeFunction('importDelegationCosts');

        $timeEnd = new \DateTime();
        $time = $timeEnd->getTimestamp() - $timeStart->getTimestamp();
        $output->writeln('Total time: '.$time.'s');
    }

    private function executeFunction($functionName)
    {
        $start = new \DateTime();
        $this->output->write('<info>'.$functionName.'</info> - ');
        $res = $this->$functionName();
        $end = new \DateTime();
        $this->output->writeln('OK (count='.$res['count'].') - '.($end->getTimestamp() - $start->getTimestamp()).'s');
    }

    private function importDelegationCosts()
    {
        $importDelegationCosts = $this->Container->get('import_delegation_costs');
        return $importDelegationCosts->import();
    }
}